#!/usr/bin/python
import plistlib, sys, platform
from distutils.version import LooseVersion

OSXVersion = LooseVersion(platform.mac_ver()[0])
IsLeopard = LooseVersion("10.5.0")

if OSXVersion >= IsLeopard:
  plistfile = "/System/Library/LaunchDaemons/com.apple.securityd.plist"
  p = plistlib.Plist.fromFile(plistfile)
  if "inactive" in sys.argv:
    p.ProgramArguments = ['/usr/sbin/securityd', '-i', '-s', 'off']
    p.write(plistfile)
  elif "active" in sys.argv:
    p.ProgramArguments = ['/usr/sbin/securityd', '-i']
    p.write(plistfile)  
else:
  plistfile = "/etc/mach_init.d/securityd.plist"
  p = plistlib.Plist.fromFile(plistfile)
  if "inactive" in sys.argv:
    p["Command"] = "/usr/sbin/securityd -s off"
    p.write(plistfile)
  elif "active" in sys.argv:
    p["Command"] = "/usr/sbin/securityd"
    p.write(plistfile)
